# バッチ設計書 1-Job Controller

## 概要

本ドキュメントは、Kubernetes Batch APIにおけるJobリソースを管理するJob Controllerの設計を記述する。Job ControllerはKubernetesのkube-controller-managerに組み込まれたコントローラーであり、Jobリソースの宣言的なワークロード管理を実現する。

### 本バッチの処理概要

Job Controllerは、Kubernetes上でバッチワークロードを管理するための中核コントローラーである。Jobリソースの仕様に基づいてPodの作成・監視・完了判定・失敗ハンドリングを実行し、指定された完了数に達するまでPodのライフサイクルを制御する。

**業務上の目的・背景**：Kubernetesクラスタ上でバッチ処理やワンショットタスクを実行するために、Podのライフサイクル管理を自動化する必要がある。Job Controllerは、ユーザーが宣言的にJobリソースを定義するだけで、Podの作成・再試行・完了判定を自動的に行い、バッチ処理の信頼性を確保する。これにより、分散環境における失敗からの自動復旧や並列バッチ処理の管理が実現される。

**バッチの実行タイミング**：Jobリソースの作成・更新・削除イベント、およびPodの状態変更イベントをInformerで監視し、イベント駆動で随時実行される。workqueue.TypedRateLimitingInterfaceを使用したレートリミット付きキューにより処理が制御される。

**主要な処理内容**：
1. Jobリソースの監視（Informer経由でAdd/Update/Deleteイベントをキャッチ）
2. Podの作成・削除管理（最大500Pod/sync、MaxPodCreateDeletePerSync定数）
3. Pod完了・失敗のカウントとステータス更新
4. 並列実行制御（Parallelism設定に基づくPod数管理）
5. インデックス付きジョブ（Indexed Completion Mode）のインデックス管理
6. Pod失敗ポリシー（PodFailurePolicy）に基づく失敗ハンドリング
7. 成功ポリシー（SuccessPolicy）による早期完了判定
8. BackoffLimit / BackoffLimitPerIndex による再試行制御
9. ファイナライザー（batch.kubernetes.io/job-tracking）による追跡管理
10. 孤立Podのファイナライザー削除（orphanQueue経由）

**前後の処理との関連**：CronJob Controllerが定期的にJobを作成する際に、Job ControllerがそのJobのPod管理を担う。TTL After Finished ControllerはJob完了後のTTLベース自動削除を担当する。

**影響範囲**：Jobリソース、Podリソース、Eventリソース。NamespaceスコープでのAPI Server操作。

## バッチ種別

コントローラーループ型（イベント駆動バッチ処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | 常時稼働 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Jobリソース・Podリソースの作成/更新/削除イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | Job Controllerはkube-controller-manager内で起動する |
| Informerキャッシュ同期完了 | PodとJobのInformerキャッシュが同期済みであること（WaitForNamedCacheSyncWithContext） |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

Informerキャッシュの同期（cache.WaitForNamedCacheSyncWithContext）が完了した場合にワーカーを起動する。同期が完了しない場合はコントローラーを起動しない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| workers | int | Yes | なし | syncワーカーの並列数（Run関数の引数） |
| SyncJobBatchPeriod | time.Duration | No | 1秒 | Job sync呼び出しのバッチ期間 |
| DefaultJobApiBackOff | time.Duration | No | 1秒 | APIバックオフのデフォルト期間 |
| MaxJobApiBackOff | time.Duration | No | 1分 | APIバックオフの最大期間 |
| DefaultJobPodFailureBackOff | time.Duration | No | 10秒 | Pod失敗バックオフのデフォルト期間 |
| MaxJobPodFailureBackOff | time.Duration | No | 10分 | Pod失敗バックオフの最大期間 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Job Informer | Kubernetes API (batch/v1 Job) | Jobリソースの変更イベントを監視 |
| Pod Informer | Kubernetes API (core/v1 Pod) | Podリソースの変更イベントを監視 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Job Status | Kubernetes API (batch/v1 Job) | Job.Status（active, succeeded, failed, conditions等）の更新 |
| Pod | Kubernetes API (core/v1 Pod) | Podの作成・削除・ファイナライザー操作 |
| Event | Kubernetes API (core/v1 Event) | Job関連イベントの記録 |

### 出力ファイル仕様

ファイル出力はなし。全てKubernetes API Server経由のリソース操作。

## 処理フロー

### 処理シーケンス

```
1. コントローラー初期化（NewController）
   └─ Informer登録、workqueue作成、expectations初期化
2. Run起動
   └─ EventBroadcaster開始、キャッシュ同期待ち、ワーカーgoroutine起動
3. ワーカーループ（worker / orphanWorker）
   └─ キューからキーを取得し、syncJob / processOrphanPodを実行
4. syncJob処理
   ├─ Jobリソース取得、所有Pod一覧取得
   ├─ 完了・失敗カウント算出
   ├─ Pod作成/削除（expectations管理下）
   ├─ ファイナライザー管理
   └─ Jobステータス更新
5. シャットダウン
   └─ キューShutDown、ワーカー終了待ち
```

### フローチャート

```mermaid
flowchart TD
    A[コントローラー起動] --> B[Informerキャッシュ同期]
    B --> C{同期完了?}
    C -->|Yes| D[ワーカーgoroutine起動]
    C -->|No| E[コントローラー終了]
    D --> F[キューからキー取得]
    F --> G[syncJob実行]
    G --> H[Job/Pod取得]
    H --> I[完了・失敗カウント]
    I --> J{Pod作成/削除必要?}
    J -->|Yes| K[Pod操作実行 max500]
    J -->|No| L[ステータス更新]
    K --> L
    L --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Pod作成 | etcd (pods) | CREATE | Job仕様に基づくPod作成 |
| Pod削除 | etcd (pods) | DELETE | 超過Pod・失敗Pod削除 |
| Job Status更新 | etcd (jobs) | UPDATE | active/succeeded/failed/conditionsの更新 |
| Job Patch | etcd (jobs) | PATCH | ファイナライザー等のパッチ適用 |
| Event記録 | etcd (events) | CREATE | Job関連イベントの記録 |

### テーブル別操作詳細

#### Job (batch/v1)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status.active | アクティブPod数 | syncJob毎に更新 |
| UPDATE | status.succeeded | 成功Pod数 | uncountedTerminatedPodsを含む |
| UPDATE | status.failed | 失敗Pod数 | uncountedTerminatedPodsを含む |
| UPDATE | status.conditions | Complete/Failed/Suspended | 状態遷移時 |
| UPDATE | status.startTime | Job開始時刻 | 初回アクティブ時 |
| UPDATE | status.completionTime | Job完了時刻 | 完了条件達成時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API Server通信エラー | API Server到達不能 | レートリミット付きリキュー |
| - | Pod作成失敗 | リソース不足等 | expectationsによる追跡、リキュー |
| - | ステータス更新競合 | 楽観的ロック競合 | リキュー（自動リトライ） |
| - | Informerキャッシュ不整合 | キャッシュ同期遅延 | expectations機構による整合性保証 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | 指数バックオフ（1秒〜1分、DefaultJobApiBackOff〜MaxJobApiBackOff） |
| リトライ対象エラー | API Serverエラー、楽観的ロック競合 |

### 障害時対応

Job Controllerが再起動した場合、Informerのキャッシュ再同期により全Jobの状態が再評価される。expectations機構により、再起動前のPod作成/削除操作の整合性が保たれる。ファイナライザーにより、Pod削除がJob Controllerに確実に通知される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Job単位（1 syncJobコール = 1 Job） |
| コミットタイミング | Pod操作後にステータス更新 |
| ロールバック条件 | ステータス更新失敗時はリキューで再試行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | MaxPodCreateDeletePerSync = 500 Pod/sync |
| 目標処理時間 | SyncJobBatchPeriod = 1秒間隔 |
| メモリ使用量上限 | MaxUncountedPods = 500（ステータス表現を約20KB以下に維持） |

## 排他制御

- workqueueによるキー単位の排他制御（同一Jobキーは同時に1ワーカーのみ処理）
- ControllerExpectationsによるPod作成/削除の楽観的排他制御
- uidTrackingExpectationsによるファイナライザー削除の追跡
- API Serverの楽観的並行性制御（ResourceVersion）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting job controller" |
| 進捗ログ | syncJob実行時（V4） | Job/Podの状態変更詳細 |
| 終了ログ | コントローラー停止時 | "Shutting down job controller" |
| エラーログ | エラー発生時 | API通信エラー、Pod操作エラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| job_sync_duration_seconds | メトリクス（Prometheusで監視） | クラスタ管理者 |
| job_pods_finished_total | メトリクス（Prometheusで監視） | クラスタ管理者 |
| workqueue深さ | メトリクス（Prometheusで監視） | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/job/job_controller.go`
- メトリクス登録: `pkg/controller/job/metrics/`
- コントローラーのGroupVersionKind: `batch/v1 Job`
- 2ワーカーキュー構成: メインのjobキュー + orphan podキュー
